
 /* ***************************************************************************+
 * ITX package (cnrg.itx) for telephony application programming.              *
 * Copyright (c) 1999  Cornell University, Ithaca NY.                         *
 * A copy of the license is distributed with this package.  Look in the docs  *
 * directory, filename GPL.  Contact information: bergmark@cs.cornell.edu     *
 ******************************************************************************/

package cnrg.itx.signal.SignalEvent;

import java.net.*;

import cnrg.itx.datax.*;
import cnrg.itx.signal.*;
import cnrg.itx.ds.*;

/** This class represents an event generated when a DTMF tone is received.
 */
public class DTMFSignalEvent extends SignalEvent
{
	/**  String representation of the DTMF tone(s) received  **/
	private String myDTMF = "";
	
	/** Default Constructor
	 * 
	 * @param ip is the InvitePacket received
	 * @param str is the string representation of the DTMF tone(s)
	 */
	public DTMFSignalEvent(InvitePacket ip, String str){
		super(ip);
		myDTMF = str;
	}
			
	/** 
	 * @return the string representation of the DTMF tone(s)
	 */
	public String getDTMF(){
		return myDTMF;
	}

}
